GreenLight
=========================================

A model of a greenhouse with HPS and LED lights, based on the DooM framework.

## Maintainers
* David Katzin, `david.katzin@wur.nl`

## In this repository

- `readme.md` - This readme file
- *Code*
	- `createBvModel` - Files for creating an object of a greenhouse model with lights
	   - `createBvModel.m` - Main function for creating a new greenhouse model object
	   - `setBvParams.m` - Set the parameters
	   - `setBvInput.m` - Set the inputs
	   - `setBvTime.m` - Set the timespan
	   - `setBvControls.m` - Set the controls 
	   - `setBvStates.m` - Set the states
	   - `setBvAux.m` - Set the auxiliary states 
	   - `setBvControlRules.m` - Set the control rules 
	   - `setBvOdes.m` - Set the ODEs
	   - `setBvInit.m` - Set the inital values for the states
	- *inputs* - Files for defining the outdoor climate inputs
	   - `loadGreenhouseData.m` - Load data from available greenhouse datasets (data not included in this repository)
	   - `loadSelYearHiRes.m` - Load outdoor data from Reference Year for Dutch Greenhouses
	   - `cloudCoverRotterdam2009-2012` - Cloud cover data in Rotterdam for the years 2009-2012
	   - `skyTempMonteith.m` - Calculate sky temperature according to a given air temperature and cloud cover
	   - `skyTempRdam.m` - Calculate sky temperature in Rotterdam according to `skyTempMonteith` and the data in `cloudCoverRotterdam2009-2012`
	   - `soilTempNl.m` - Calculate soil temperature for Dutch conditions
	- *postSimAnalysis* - Methods for analyzing and viewing the simulation after it's done
	   - `plotTemps.m` - Plot the temperatures of the various states in the model
	   - `verveer.mat` - Table relating pipe temperature and diameter to energy use
	   - `verveerReadme.txt` - Explanation regarding the table in `vermeer.mat`
	   - `pipeT2EnergyIn.m` - Calculates how much energy came from the pipe, based on pipe temperature and the table by Verveer
	   - `groPipeEnergy.m` - Calculates how much energy came from the grow pipes
	   - `pipeEnergy.m` - Calculates how much energy came from the pipe rails	   
	   - `energyAnalysis.m` - Prints out the values of the simultaed energy balance
	- *runScenarios* - Scenarios considered in the current study
	